/*!
 * @file        main.c
 *
 * @brief       Main program body
 *
 * @version     V1.0.0
 *
 * @date        2022-02-25
 *
 * @attention
 *
 *  Copyright (C) 2021-2022 Geehy Semiconductor
 *
 *  You may not use this file except in compliance with the
 *  GEEHY COPYRIGHT NOTICE (GEEHY SOFTWARE PACKAGE LICENSE).
 *
 *  The program is only for reference, which is distributed in the hope
 *  that it will be usefull and instructional for customers to develop
 *  their software. Unless required by applicable law or agreed to in
 *  writing, the program is distributed on an "AS IS" BASIS, WITHOUT
 *  ANY WARRANTY OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the GEEHY SOFTWARE PACKAGE LICENSE for the governing permissions
 *  and limitations under the License.
 */

#include "main.h"
#include "bsp_lcd.h"
#include "bsp_lcdFont.h"
#include <stdio.h>
#include "bsp_delay.h"
#include "bsp_usart.h"
#include "bsp_touch.h"
#include "app.h"

/** public variables*/
uint16_t lcdWidth;
uint16_t lcdHight;

/*!
 * @brief       Main program
 *
 * @param       None
 *
 * @retval      None
 *
 */
int main(void)
{
    /** Horizontal */
    lcdWidth = LCD_SIDE_LONG;
    lcdHight = LCD_SIDE_SHORT;

    /** Set system interrupt priority grouping */
    NVIC_ConfigPriorityGroup(NVIC_PRIORITY_GROUP_1);

    /** Init delay function */
    Delay_Init();

    /** Init LED */
    APM_EVAL_LEDInit(LED1);
    APM_EVAL_LEDInit(LED2);
    APM_EVAL_LEDInit(LED3);

    /** Init USART */
    USART1_Init(115200);
    
    /** Init LCD*/
    LCD_GPIO_Init();
    LCD_SMC_Init();
    LCD_Reset();
    LCD_ConfigRegister();
    LCD_EnableBackLight();

    LCD_ConfigScan(LCD_SCAN_MODE_5);
    LCD_ClearScreen();

    /** Display default UI*/
    Touch_DisplayInitUI();
    
    /** Touch board init*/
    TouchBoard_Init();
    
    /**
     *  The data of the ouch chip will be processed in
     *  the interrupt callback function TouchBoard_Process()
     */
    
    while(1)
    {
        Touch_EventHandle();
    }
}
